/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.property;

import filenet.vw.api.VWException;
import filenet.vw.api.VWWorkObject;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.VWTrkDataModel;
import filenet.vw.toolkit.runtime.dialog.VWManageTrackersDialog;
import filenet.vw.toolkit.runtime.property.images.VWImageLoader;
import filenet.vw.toolkit.runtime.property.resources.VWResource;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeListener;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.event.VWPropertyChangeNotifier;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;

public class VWWorkflowTrackerPanel
extends JPanel
implements IVWPropertyChangeListener {
    private Frame m_parentFrame = null;
    private VWTrkDataModel m_trackerDataModel = null;
    private boolean m_bManagingTrackers = false;
    private JList m_trackerList = null;
    private Vector m_trackerObjects = new Vector();
    private AbstractButton m_manageTrackerBtn = null;
    private AbstractListModel m_trackerListModel = null;
    private ActionListener m_manageTrackerListener = null;
    private MouseAdapter m_trackerListMouseAdapter = null;
    private VWLabelListCellRenderer m_trackerListRenderer = new VWLabelListCellRenderer();

    public VWWorkflowTrackerPanel(Frame parentFrame, VWTrkDataModel dataModel) {
        this.m_parentFrame = parentFrame;
        this.m_trackerDataModel = dataModel;
        this.initializeVars();
        this.setupLayout();
    }

    public void initialize() {
        if (this.m_trackerDataModel.getInitState() == 6) {
            this.updateTrackerListUI();
            VWPropertyChangeNotifier.addPropertyChangeListener(this);
        }
    }

    private void setupLayout() {
        this.m_manageTrackerBtn = VWImageLoader.createToolBarButton("manage_trackers.gif", VWResource.s_manageTrackers, false);
        this.m_manageTrackerBtn.setRolloverEnabled(true);
        this.m_manageTrackerBtn.setMargin(new Insets(0, 0, 0, 0));
        this.m_manageTrackerBtn.addActionListener(this.m_manageTrackerListener);
        this.m_manageTrackerBtn.setEnabled(this.m_trackerDataModel.getCanManageTrackers());
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        JPanel trackerButtonPanel = new JPanel();
        trackerButtonPanel.setLayout(new BorderLayout());
        trackerButtonPanel.add((Component)this.m_manageTrackerBtn, "After");
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 23;
        c.insets = new Insets(0, 6, 0, 0);
        this.add((Component)trackerButtonPanel, c);
        c.gridy = -1;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.m_trackerList = new JList(this.m_trackerListModel);
        this.m_trackerList.addMouseListener(this.m_trackerListMouseAdapter);
        this.m_trackerList.setSelectionMode(0);
        this.m_trackerList.setCellRenderer(this.m_trackerListRenderer);
        this.m_trackerList.setSelectedIndex(0);
        this.add((Component)new JScrollPane(this.m_trackerList), c);
    }

    private void getListOfTrackers() {
        this.m_trackerObjects = (Vector)this.m_trackerDataModel.getNoDuplicateTrackerList().clone();
    }

    private void createTrackerListPopup(JList list, Point point) {
        JMenuItem mi = null;
        JPopupMenu popup = new JPopupMenu();
        mi = popup.add(new JMenuItem(VWResource.s_manageTrackers));
        mi.addActionListener(this.m_manageTrackerListener);
        mi.setEnabled(this.m_trackerDataModel.getCanManageTrackers());
        popup.show(list, point.x, point.y);
    }

    private void initializeVars() {
        this.m_trackerListModel = new AbstractListModel(){

            public int getSize() {
                return VWWorkflowTrackerPanel.this.m_trackerObjects.size();
            }

            public Object getElementAt(int index) {
                Object obj = VWWorkflowTrackerPanel.this.m_trackerObjects.elementAt(index);
                if (obj instanceof VWWorkObject) {
                    VWWorkObject trackerWorkObject = (VWWorkObject)obj;
                    try {
                        VWParticipantItem pItem = new VWParticipantItem(trackerWorkObject.getParticipantNamePx());
                        return new JLabel(pItem.getDisplayName());
                    }
                    catch (VWException ex) {
                        VWDebug.logException(ex);
                    }
                }
                return null;
            }
        };
        this.m_manageTrackerListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VWWorkflowTrackerPanel.this.performManageTrackers();
            }
        };
        this.m_trackerListMouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent event) {
                if (event.isPopupTrigger()) {
                    this.showPopup(event);
                }
            }

            public void mouseReleased(MouseEvent event) {
                if (event.isPopupTrigger()) {
                    this.showPopup(event);
                }
            }

            private void showPopup(MouseEvent event) {
                Object source = event.getSource();
                if (source instanceof JList) {
                    JList list = (JList)source;
                    Point point = event.getPoint();
                    int index = list.locationToIndex(point);
                    if (index == -1) {
                        list.clearSelection();
                    } else {
                        list.setSelectedIndex(index);
                    }
                    VWWorkflowTrackerPanel.this.createTrackerListPopup(list, point);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performManageTrackers() {
        VWManageTrackersDialog dialog = null;
        if (this.m_bManagingTrackers) {
            return;
        }
        try {
            this.m_bManagingTrackers = true;
            dialog = new VWManageTrackersDialog(this.m_parentFrame, this.m_trackerDataModel);
            dialog.setVisible(true);
            if (!dialog.isCanceled()) {
                try {
                    this.m_trackerDataModel.refreshTrackerList();
                }
                catch (VWException ex) {
                    this.logShowException(ex, VWResource.s_refreshListOfTrackers);
                }
            }
        }
        catch (Exception ex) {
            this.logShowException(ex, VWResource.s_manageTrackers);
        }
        finally {
            if (dialog != null) {
                dialog.removeReferences();
                dialog = null;
            }
        }
        this.m_bManagingTrackers = false;
    }

    public void propertyChange(VWPropertyChangeEvent event) {
        Object obj = event.getSource();
        if (obj == null) {
            return;
        }
        if (obj instanceof IVWPropertyChangeSource) {
            IVWPropertyChangeSource source = (IVWPropertyChangeSource)obj;
            int type = event.getID();
            switch (type) {
                case 704: 
                case 705: 
                case 710: {
                    this.updateTrackerListUI();
                }
            }
        }
    }

    public void updateInfo() {
        this.updateTrackerListUI();
    }

    private void updateTrackerListUI() {
        this.getListOfTrackers();
        this.m_trackerList.updateUI();
        this.m_manageTrackerBtn.setEnabled(this.m_trackerDataModel.getCanManageTrackers());
    }

    private void logShowException(Exception ex, String title) {
        VWDebug.logException(ex);
        String msg = ex.getLocalizedMessage();
        if (msg == null || msg.length() == 0) {
            msg = ex.getClass().getName();
        }
        JOptionPane.showMessageDialog(this.m_parentFrame, msg, title, 0, null);
    }

    public void removeReferences() {
        VWPropertyChangeNotifier.removePropertyChangeListener(this);
        this.m_manageTrackerBtn.removeActionListener(this.m_manageTrackerListener);
        this.m_trackerList.setCellRenderer(null);
        this.m_trackerList.removeMouseListener(this.m_trackerListMouseAdapter);
        this.m_parentFrame = null;
        this.m_trackerDataModel = null;
        if (this.m_trackerList != null) {
            this.m_trackerList.removeAll();
            this.m_trackerList = null;
        }
        if (this.m_trackerObjects != null) {
            this.m_trackerObjects.removeAllElements();
            this.m_trackerObjects = null;
        }
        this.m_manageTrackerBtn = null;
        this.m_trackerListModel = null;
        this.m_manageTrackerListener = null;
        this.m_trackerListMouseAdapter = null;
        this.m_trackerListRenderer = null;
        VWPropertyChangeNotifier.removePropertyChangeListener(this);
    }
}

